/* Add table "notif_inbox"                                                   */

CREATE TABLE notiftable_inbox (
   inbox_id NUMBER GENERATED by default on null as IDENTITY,
   notif_id NUMBER(10) NOT NULL,
   login VARCHAR2(255) NOT NULL,
   notif_dtsent TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
   notif_ontop NUMBER(10) DEFAULT 0,
   notif_isread NUMBER(10) DEFAULT 0,
   notif_dtread TIMESTAMP DEFAULT NULL,
   notif_tags VARCHAR2(255) DEFAULT NULL,
   notif_important NUMBER(10) DEFAULT NULL,
   PRIMARY KEY (inbox_id)
)

/* Add table "notif_pref"                                                   */

CREATE TABLE notiftable_pref (
  login VARCHAR2(255) NOT NULL,
  receive_email NUMBER(10)  DEFAULT '0',
  receive_sms NUMBER(10)  DEFAULT '0',
  PRIMARY KEY (login)
)

/* Add table "notif_tags"                                                   */

CREATE TABLE notiftable_tags (
  tag_id NUMBER GENERATED by default on null as IDENTITY,
  tag_title VARCHAR2(50) NOT NULL,
  login VARCHAR2(255) NOT NULL,
  tag_color VARCHAR2(100) DEFAULT NULL,
  tag_active NUMBER(10)  DEFAULT '1',
  PRIMARY KEY (tag_id)
)

/* Add table "notif_notifications"                                                   */

CREATE TABLE notiftable_notifications (
    notif_id NUMBER GENERATED by default on null as IDENTITY,
    notif_title VARCHAR2(255) NOT NULL,
    notif_message clob NOT NULL,
    notif_dtcreated timestamp DEFAULT CURRENT_TIMESTAMP,
    notif_ontop NUMBER(10) DEFAULT '0',
    notif_dtexpire timestamp DEFAULT NULL,
    notif_categ VARCHAR2(60) DEFAULT NULL,
    notif_login_sender VARCHAR2(255) NOT NULL,
    notif_type VARCHAR2(60) DEFAULT NULL,
    notif_link VARCHAR2(255) DEFAULT NULL,
    deleted_at timestamp DEFAULT NULL,
    PRIMARY KEY (notif_id)
)

/* Add table "notif_profiles"                                                   */

CREATE TABLE notiftable_profiles (
    profile_id NUMBER GENERATED by default on null as IDENTITY,
    profile_name VARCHAR2(255) NOT NULL,
    profile_users clob NULL,
    profile_groups clob NULL,
    profile_public NUMBER(10) DEFAULT '0',
    profile_owner VARCHAR2(255) NULL,
    PRIMARY KEY (profile_id)
)

/* Add table "notif_user_tags"                                                   */

CREATE TABLE notiftable_user_tags (
    user_tags_id NUMBER GENERATED by default on null as IDENTITY,
    login VARCHAR2(255) NOT NULL,
    login_sender VARCHAR2(255) NOT NULL,
    tags VARCHAR2(255) DEFAULT NULL,
    PRIMARY KEY (user_tags_id)

)


