<?php
//__NM____NM__FUNCTION__NM__//


function createMenuStructure($aOrder, &$aList, $sParent, $aLabels){
	foreach ($aOrder as $iCat => $aCats) {
	    $sMenuId = 'mid_' . $iCat;
	    $aList[] = array(
	                     'id'     => $iCat,
	                     'mid'    => $sMenuId,
	                     'label'  => $aLabels[$iCat],
	                     'parent' => $sParent,
	                    );
	
	    createMenuStructure($aCats, $aList, $sMenuId, $aLabels);
	}
}

function getCategoriesTree(){
	$sSql = "SELECT categoryid,
	                categoryname,
	                categoryparent
	         FROM kb_categories";
	
	sc_lookup(ds_cat, $sSql);
	
	if (false === {ds_cat})  { return false;   }
	elseif (empty({ds_cat})) { return array(); }
	else {
	    $aNewOrder = array();
	
	    foreach ({ds_cat} as $iCat => $aData) {
	        insertCategory($aData, $aNewOrder, 0);
	    }
	
	    return $aNewOrder;
	} 
}

function getCategoryLabels(){

	$sSql = "SELECT categoryid,
	                categoryname
	         FROM kb_categories";
	
	sc_lookup(ds_cat, $sSql);
	
	if (false === {ds_cat})  { return false;   }
	elseif (empty({ds_cat})) { return array(); }
	else {
	    $aLabels = array();
	
	    foreach ({ds_cat} as $iCat => $aData) {
	        $aLabels[ $aData[0] ] = $aData[1];
	    }
	
	    return $aLabels;
	}
}

function insertCategory($aCat, &$aOrder, $iLevel){

	$iCatId     = $aCat[0];
	$sCatLabel  = $aCat[1];
	$iCatParent = $aCat[2];
	
	if (0 == $iLevel && 0 == $iCatParent) {
	    $aOrder[$iCatId] = array();
	}
	else {
	    foreach ($aOrder as $iIndex => $aList) {
	        if ($iIndex == $iCatParent) {
	            $aOrder[$iCatParent] [$iCatId] = array();
	        }
	        elseif (!empty($aOrder[$iIndex])) {
	            insertCategory($aCat, $aOrder[$iIndex], $iLevel + 1);
	        }
	    }
	}
}

function getRatingStars($total,$qty){

	if(empty($total) || empty($qty)) return ' ';	
	$votes = (int)$total / $qty;
	$str_img = '';
	for($i=0;$i<$votes;$i++){
		$str_img .= "<img src='../_lib/img/star_icons20.gif' />";
	}
	return $str_img;
	
}

?>